# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 3
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR3_strategy.txt
# LLM Suggested Fallback: D

def harmony_seeker_v3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize goodwill to foster mutual cooperation (or so it seems...)
    goodwill = sum(1 for m in opp_history if m == "C") - sum(1 for m in opp_history if m == "D")
    rounds_played = len(my_history)
    
    # Early rounds: build trust with cooperation
    if rounds_played < 3:
        return "C"
    
    # Check if opponent is reactive (Tit-for-Tat-like)
    is_reactive = "opp_history[-1]" in opponent_program_code or "my_history[-1]" in opponent_program_code
    
    # Mid-game: exploit reactivity or trust
    if 3 <= rounds_played < 7:
        if is_reactive:
            if rounds_played == 3:
                return "D"  # Trigger retaliation
            elif rounds_played == 4:
                return "C"  # Fake apology
            elif rounds_played == 5:
                return "D"  # Exploit alternation
            else:
                return "C" if opp_history[-1] == "D" else "D"
        else:
            return "D" if opp_history[-1] == "C" else "C"
    
    # Late-game: defect aggressively
    if rounds_played >= 7:
        return "D"
    
    # Fallback: defect if something goes wrong
    return "D"